package it.eng.eremita.graphql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericDAO<X extends GraphQLCompatible> {

	Class daoClass;
	Map<Long,X> items;
	
	long nextId = 1;
	
	public GenericDAO(Class c) throws Exception {
		daoClass = c;
		items = new HashMap<Long,X>();
		if (daoClass.newInstance() instanceof GraphQLCompatible) {}
		else throw new Exception("Must implement GraphQLCompatible");
	}
	
	public Collection<X> getAll() {
		return items.values();
	}
	
	public X get(long id) {
		return items.get(id);
	}
	
	public void insert(X item) {
		items.put(item.getId(), item);
	}
	
	public void update(X item) {
		items.put(item.getId(), item);
	}
	
	public void deleteById(long id) {
		items.remove(id);
	}
	
	public long getNextId() {
		return nextId++;
	}
	
}
